---
tags: outlook project writing
---

Goal-oriented outlook for large-scale personal projects seem to be detrimental in a sense that in the absence of an enforcing agent it seems to be contributing to issues like will-power dissolution, decision fatigue, burn-out, guilt etc owing to the disincentives of self-enforced adherence to an idea/project for a long term. This is based on the idea by Kurzban et. al that overcommiting to a task, that is only expected to show its result in distant future, can dissolve will power to an extent of a burnout or complete unproductivity. And in my opinion, it not just affects the quantifiable components, it also affects your qualitative components like creative autonomy.

After talking with few interesting people and trying out various different processes myself I have come to the conclusion that some of the strategies mentioned below can help in persistance of motivation in a long term personal project without any unnatural self-enforced adherence. I call it serendipity-based outlook because the diversion[[...'I bounce between projects to maintain my interest. (In Kurzban's theory, willpower seems to reflect opportunity cost and a built-in aversion to overcomitting to a task which hasn't delivered any large rewards yet, and switching regularly helps prevent burnout.) Since many of my pages are incremental, there's always little things to be done'...<br/><cite>---Email Exchange with Gwern</cite>::lsn]]. from the singular focus towards the main project seems to be allowing for some kind unexpected results and epiphanies as byproducts.

Working Strategies:

- Multiple projects requiring varying degree of proficiency with the main one allowing the maintenance of a Flow State(i.e., not too difficult to deprive you of maintaining motivation, not too easy to be waded off as trivial, one that can challenge you while using your current level of understanding). And Constantly bouncing between them as an alternative to the main one.
- Stretches of idle days working on nothing or random things can lead to surprising results **See:** [[Nassim Taleb on this::https://m.facebook.com/nntaleb/posts/10152466038423375]] and [[Bertrand Russell on the praise of this::https://harpers.org/archive/1932/10/in-praise-of-idleness/]].
- Frequent alternation between recreational projects like writing, blogging etc as an anti-dote to the side-effects of the main project.
- Undirected effort(such as researching) effort towards a sub-goal. Letting serendipity take over.[[...'Having no set goal in mind means you are not worried about completing anything. Also lately, I’m finding things are more interconnected than they seem. So whatever I learn contributes to a the whole than narrowing down to a slice of it'...<br/><cite>---Twitter Exchange with Prathyush</cite>::rsn]]
- [[Do Things That Don't Scale::https://paulgraham.com/ds.html]]

**\*\***One thing that I have been observing is multiyear projects with smaller-side projects can help incorporate the Hybrid Routine Easily.\*

---

## References

Baumeister & Tierney. (2011). _[[Do You Suffer From Decision Fatigue::https://www.nytimes.com/2011/08/21/magazine/do-you-suffer-from-decision-fatigue.html?pagewanted=all]]_

> ...‘Good decision making is not a trait of the person, in the sense that it’s always there,’ Baumeister says. ‘It’s a state that fluctuates.’ His studies show that people with the best self-control are the ones who structure their lives so as to conserve willpower. They don’t schedule endless back-to-back meetings. They avoid temptations like all-you-can-eat buffets, and they establish habits that eliminate the mental effort of making choices. Instead of deciding every morning whether or not to force themselves to exercise, they set up regular appointments to work out with a friend. Instead of counting on willpower to remain robust all day, they conserve it so that it’s available for emergencies and important decisions….’Even the wisest people won’t make good choices when they’re not rested and their glucose is low,’ Baumeister points out. That’s why the truly wise don’t restructure the company at 4 p.m. They don’t make major commitments during the cocktail hour. And if a decision must be made late in the day, they know not to do it on an empty stomach. ‘The best decision makers,’ Baumeister says, ‘are the ones who know when not to trust themselves.’...

Conversation with [[Gwern Branwen::https://twitter.com/gwern]]. (2019-Dec-19). _Email Exchange_

> ...'I bounce between projects to maintain my interest. (In Kurzban's theory, willpower seems to reflect opportunity cost and a built-in aversion to overcomitting to a task which hasn't delivered any large rewards yet, and switching regularly helps prevent burnout.) Since many of my pages are incremental, there's always little things to be done'...

Conversation with [[Prathyush Pramod::https://twitter.com/prathyvsh]]. (2019-Nov-15th). _Twitter Exchange_

> ...'Having no set goal in mind means you are not worried about completing anything. Also lately, I’m finding things are more interconnected than they seem. So whatever I learn contributes to a the whole than narrowing down to a slice of it'...

Taleb, Nicholas Nassim. (2015). _Antifragile_

Taleb, Nicholas Nassim. (2018). _[[Twitter thread on routine::https://twitter.com/nntaleb/status/1029812693660848129]]_

> Routine is effortless. Most humans, alas, prefer to expend physical, never intellectual energy. Creating requires much, much more effort.

Graham, Paul. (2013). [[Do Things That Don't Scale::https://paulgraham.com/ds.html]]

My Journal Entry, Jan 6th 2019

> Clearly, my brain has learned to ignore the Google calendar notifications. Initially, scheduling and completely the event/task used to feel rewarding, so I built up on that and kept adding trivial items in my calendar like gym, writing, journaling, etc. Although it worked for a couple of days, somehow there was a behavioral shift in how I was responding to the notifications, now it was not only the trivial ones that I was ignoring, the important ones too got side-tracked as a result of decision fatigue.
>
> Although the extremely important ones had this aging process of incremental prioritization owing to [[Parkinson's Law::https://en.wikipedia.org/wiki/Parkinson%27s_law]].
>
> > **_Parkinson's Law:_** Work expands so as to fill the time available for its completion
